define(['DirectSchedulingService','ChangeLocationModalController'], function () {
	'use strict';

	describe('Change location controller', function () {
		var scope,
			controller,
			mhpuser,
			stateMock,
			stateParamsMock,
      fakeModal = {
          result: {
              then: function() {}
          },
          close: function() {},
          dismiss: function() {}
      },
			institutionsServiceMock;

		beforeEach(function() {
			module('angularTemplateApp');

			stateMock = {
				go: function(){}
			};

			stateParamsMock = {
				moduleName: "VAR Utility",
				primaryHeaderTitle: "Select Facility Location"
			};

			institutionsServiceMock = {
				institutions: {
					data: [

					]
				},
				setActiveInstitution: function(){}
			};

			spyOn(institutionsServiceMock,'setActiveInstitution');
			spyOn(stateMock,'go');

			module(function($provide) {
				$provide.value('$state',stateMock);
				$provide.value('$stateParams',stateParamsMock);
				$provide.value('InstitutionsService',institutionsServiceMock);
			});

			inject(function($rootScope, $controller) {
				scope = $rootScope.$new();
				controller = $controller('ChangeLocationModalController', {$scope:scope, $stateParams: stateParamsMock, $modalInstance:fakeModal});
			});

      inject(function($modal) {
          spyOn($modal, 'open').andReturn(fakeModal);
          spyOn(fakeModal, 'close');
      });
		});

		it('sets scope variables properly from service values and state params', function () {
			expect(scope.primaryHeaderTitle).toEqual('VAR Utility - Select Facility Location');
			expect(scope.parentFacilityName).toEqual('Test Facility');
			expect(scope.userFirstLastName).toEqual('Test First Test Last');
		});

		xit('should sort institution dropdown options alphabetically, but always put the parent facility first', function () {
			// TODO: had lots of problems getting this test to work properly, given the async nature of InstitutionsService
			// (even using waitsFor()). Will need to revisit this test when we go to clean up the rest of these tests.
		});
	});

  describe("when the OK button is clicked", function (){
      beforeEach( function () {
        scope.ok();
      });

      it('on ok() updates the active institution in the institutions service and forwards the user to the main var-utility page', function() {
        var institutionSelection = {
  				dummyField: "dummy data"
  			};
  			scope.openSettings(institutionSelection);
  			expect(institutionsServiceMock.setActiveInstitution)
  				.toHaveBeenCalledWith(institutionSelection);
  			expect(stateMock.go)
  				.toHaveBeenCalledWith("main.auth.two-panel.secondary-navigation.var-utility");
        expect(fakeModal.close).toHaveBeenCalled();
      });
   });
});
